`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 12/11/2023 09:54:43 PM
// Design Name: 
// Module Name: control_unit
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////


module control_unit(
         clk,
         rst_n,
         ir,
         flags,
         P,
         A,
         LAlt_AC,
         LAlt_MBR,
         debug_microop
    );
    
    parameter word_width  = 16;
    parameter flag_width  = 2;
    parameter state_width = 8;
    parameter debug_state_width = 10;
    
    input                    clk;
    input                    rst_n;
    input [word_width-1 : 0] ir;
    input [flag_width-1 : 0] flags;                 /*flags[1] - S(sign), flags[0] - Z(zero)*/
    output reg [5:0]         P;
    output reg [2:0]         A;
    output reg               LAlt_AC;
    output reg               LAlt_MBR;
    output reg [7:0]         debug_microop;
    
    //define states
    `define reset                   'h00            /* reset state */
    `define fetch                   'h10            /* load instruction to instruction register */
    `define decode                  'h20            /* analyze loaded instruction */
    `define exec_store              'h30            /**/
    `define exec_storeI             'h35            /**/ 
    `define exec_load               'h40            /**/  
    `define exec_add                'h50            /**/ 
    `define exec_jump               'h60            /**/ 
    `define exec_output             'h70            /**/ 
    
    //define register addresses
    `define ir_we                   3'd7
    `define ir_oe                   3'd7
    `define out_we                  3'd6
    `define out_oe                  3'd6
    `define in_we                   3'd5
    `define in_oe                   3'd5
    `define ac_we                   3'd4
    `define ac_oe                   3'd4
    `define mbr_we                  3'd3
    `define mbr_oe                  3'd3
    `define pc_we                   3'd2
    `define pc_oe                   3'd2
    `define mar_we                  3'd1
    `define mar_oe                  3'd1
    `define ram_we                  3'd0
    `define ram_oe                  3'd0
    `define regs_nop                3'd0
    
    //define commands
    `define load                    4'h1
    `define store                   4'h2
    `define add                     4'h3
    `define output                  4'h6
    `define jump                    4'h9
    `define storeI                  4'hE
    
    reg [state_width-1 : 0]       state = `reset, state_next;
    reg [8*debug_state_width-1:0] debug_state;
        
    // FSM - sequential part
    always @(posedge clk) begin
        state <= `reset;
    
        if(rst_n)
            state <= state_next;
    end
    
    always @(*) begin
        state_next    = `reset;
        debug_state   = "-";
        debug_microop = 0;
        P = 0;
        A = 0;
        LAlt_AC = 0;
        LAlt_MBR= 0;
        
        case(state)
            `reset: begin
                state_next = `fetch;
            end

            `fetch: begin
                //Action
                P = {`mar_we, `pc_oe};
                //Transition
                state_next = `fetch + 1;
                //Debug Info
                debug_state = "fetch";
                debug_microop[0] = 1;
                
            end

            `fetch + 'd1: begin
                //Action
                P = {`mbr_we, `ram_oe};
                //Transition
                state_next = `fetch + 2;
                //Debug Info
                debug_state = "fetch";
                debug_microop[1] = 1;
            end

            `fetch + 'd2: begin
                //Action
                P = {`ir_we, `mbr_oe};
                //Transition
                state_next = `decode;
                //Debug Info
                debug_state = "fetch";
                debug_microop[2] = 1;
            end
            
            `decode: begin
                //Action
                A[2] = 1;                             //increment PC
                //Transition
                case(ir[15:12])
                    `load:  state_next = `exec_load;
                    `store: state_next = `exec_store;
                    `add:   state_next = `exec_add;
                    `output:state_next = `exec_output;
                    `jump:  state_next = `exec_jump;
                    `storeI:state_next = `exec_storeI;
                endcase
               
                //Debug Info
                debug_state = "decode";
                debug_microop[3] = 1;
            end   
            
            `exec_load: begin
                //Action
                P = {`mar_we, `ir_oe};
                //Transition
                state_next = `exec_load + 1;
                //Debug Info
                debug_state = "exec_load";
                debug_microop[4] = 1;
            end  
            `exec_load + 1: begin
                //Action
                P = {`mbr_we, `ram_oe};
                //Transition
                state_next = `exec_load + 2;
                //Debug Info
                debug_state = "exec_load";
                debug_microop[5] = 1;
            end    
            `exec_load + 2: begin
                //Action
                P = {`ac_we, `mbr_we};
                //Transition
                state_next = `fetch;
                //Debug Info
                debug_state = "exec_load";
                debug_microop[6] = 1;
            end
            
            `exec_store: begin
                //Action
                P = {`mar_we, `ir_oe};
                //Transition
                state_next = `exec_store + 1;
                //Debug Info
                debug_state = "exec_store";
                debug_microop[4] = 1;
            end
            `exec_store + 1: begin
                //Action
                P = {`mbr_we, `ac_oe};
                //Transition
                state_next = `exec_store + 2;
                //Debug Info
                debug_state = "exec_store";
                debug_microop[5] = 1;
            end  
            `exec_store + 2: begin
                //Action
                P = {`ram_we, `mbr_oe};
                //Transition
                state_next = `fetch;
                //Debug Info
                debug_state = "exec_store";
                debug_microop[6] = 1;
            end
            
            `exec_add: begin
                //Action
                P = {`mar_we, `ir_oe};
                //Transition
                state_next = `exec_add + 1;
                //Debug Info
                debug_state = "exec_add";
                debug_microop[4] = 1;
            end
            `exec_add + 1: begin
                //Action
                P = {`mbr_we, `ram_oe};
                //Transition
                state_next = `exec_add + 2;
                //Debug Info
                debug_state = "exec_add";
                debug_microop[5] = 1;
            end
            `exec_add + 2: begin
                //Action
                P = {`ac_we, `regs_nop};
                LAlt_AC = 1;
                A[1:0] = 1;
                //Transition
                state_next = `fetch;
                //Debug Info
                debug_state = "exec_add";
                debug_microop[6] = 1;
            end    
            `exec_jump: begin
                //Action
                P = {`pc_we, `ir_oe};
                //Transition
                state_next = `fetch;
                //Debug Info
                debug_state = "exec_jump";
                debug_microop[4] = 1;
            end
            `exec_storeI: begin
                 //Action
                P = {`mar_we, `ir_oe};
                //Transition
                state_next = `exec_storeI+1;
                //Debug Info
                debug_state = "exec_storeI";
                debug_microop[4] = 1;
            end
            `exec_storeI+1: begin
                 //Action
                P = {`mbr_we, `ram_oe};
                //Transition
                state_next = `exec_storeI+2;
                //Debug Info
                debug_state = "exec_storeI";
                debug_microop[5] = 1;
            end
            `exec_storeI+2: begin
                 //Action
                P = {`mar_we, `mbr_oe};
                //Transition
                state_next = `exec_storeI+3;
                //Debug Info
                debug_state = "exec_storeI";
                debug_microop[6] = 1;
            end
            `exec_storeI+3: begin
                 //Action
                P = {`mbr_we, `ac_oe};
                //Transition
                state_next = `exec_storeI+4;
                //Debug Info
                debug_state = "exec_storeI";
                debug_microop[7] = 1;
            end
            `exec_storeI+4: begin
                 //Action
                P = {`ram_we, `mbr_oe};
                //Transition
                state_next = `fetch;
                //Debug Info
                debug_state = "exec_storeI";
                
            end
            `exec_output: begin
                //Action
                P = {`out_we, `ac_oe};
                //Transition
                state_next = `fetch;
                //Debug Info
                debug_state = "exec_output";
                debug_microop[4] = 1;
            end
            
        endcase
            
        end
endmodule
